/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.common.entity.TurretEntity;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_TurretSettingsPacket
extends AbstractNetworkPacket<C2S_TurretSettingsPacket> {
    private final int turretId;
    private final SettingsType settingsType;
    private final TurretEntity.TargettingMode targettingMode;
    private final WhitelistOperation whitelistOperation;
    private final UUID playerId;

    public C2S_TurretSettingsPacket() {
        this(0, null, null, null, null);
    }

    private C2S_TurretSettingsPacket(int turretId, SettingsType settingsType, TurretEntity.TargettingMode targettingMode, WhitelistOperation whitelistOperation, UUID playerId) {
        this.turretId = turretId;
        this.settingsType = settingsType;
        this.targettingMode = targettingMode;
        this.whitelistOperation = whitelistOperation;
        this.playerId = playerId;
    }

    public static C2S_TurretSettingsPacket setTargettingMode(TurretEntity turret, TurretEntity.TargettingMode targettingMode) {
        return new C2S_TurretSettingsPacket(turret.func_145782_y(), SettingsType.TARGETTING_MODE, targettingMode, null, null);
    }

    public static C2S_TurretSettingsPacket whitelistPacket(TurretEntity turret, WhitelistOperation operation, UUID playerId) {
        return new C2S_TurretSettingsPacket(turret.func_145782_y(), SettingsType.WHITELIST, null, operation, playerId);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.turretId);
        buffer.func_179249_a((Enum)this.settingsType);
        this.settingsType.encoder.accept(this, buffer);
    }

    @Override
    public C2S_TurretSettingsPacket decode(PacketBuffer buffer) {
        int turretId = buffer.readInt();
        SettingsType settingsType = (SettingsType)buffer.func_179257_a(SettingsType.class);
        return settingsType.decoder.decode(turretId, settingsType, buffer);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        TurretEntity turret;
        ServerPlayerEntity sender = context.getSender();
        ServerWorld world = sender.func_71121_q();
        Entity entity = world.func_73045_a(this.turretId);
        if (entity instanceof TurretEntity && (turret = (TurretEntity)entity).isAuthorized((PlayerEntity)sender)) {
            this.settingsType.handler.accept(this, turret);
        }
    }

    private TurretEntity.TargettingMode getTargettingMode() {
        return this.targettingMode;
    }

    private WhitelistOperation getWhitelistOperation() {
        return this.whitelistOperation;
    }

    private UUID getPlayerId() {
        return this.playerId;
    }

    public static enum WhitelistOperation {
        ADD,
        REMOVE;

    }

    private static enum SettingsType {
        TARGETTING_MODE((pkt, buf) -> {
            TurretEntity.TargettingMode mode = ((C2S_TurretSettingsPacket)pkt).getTargettingMode();
            buf.func_179249_a((Enum)mode);
        }, (id, type, buf) -> {
            TurretEntity.TargettingMode mode = (TurretEntity.TargettingMode)buf.func_179257_a(TurretEntity.TargettingMode.class);
            return new C2S_TurretSettingsPacket(id, type, mode, null, null);
        }, (pkt, turret) -> {
            TurretEntity.TargettingMode targettingMode = ((C2S_TurretSettingsPacket)pkt).getTargettingMode();
            turret.setTargettingMode(targettingMode);
        }),
        WHITELIST((pkt, buf) -> {
            WhitelistOperation operation = ((C2S_TurretSettingsPacket)pkt).getWhitelistOperation();
            UUID playerId = ((C2S_TurretSettingsPacket)pkt).getPlayerId();
            buf.func_179249_a((Enum)operation);
            buf.func_179252_a(playerId);
        }, (id, type, buf) -> {
            WhitelistOperation operation = (WhitelistOperation)buf.func_179257_a(WhitelistOperation.class);
            UUID playerId = buf.func_179253_g();
            return new C2S_TurretSettingsPacket(id, type, null, operation, playerId);
        }, (pkt, turret) -> {
            WhitelistOperation operation = ((C2S_TurretSettingsPacket)pkt).getWhitelistOperation();
            UUID playerId = ((C2S_TurretSettingsPacket)pkt).getPlayerId();
            BiConsumer<TurretEntity, UUID> op = operation == WhitelistOperation.ADD ? TurretEntity::addToWhitelist : TurretEntity::removeFromWhitelist;
            op.accept((TurretEntity)turret, playerId);
        });

        private final BiConsumer<C2S_TurretSettingsPacket, PacketBuffer> encoder;
        private final Decoder decoder;
        private final BiConsumer<C2S_TurretSettingsPacket, TurretEntity> handler;

        private SettingsType(BiConsumer<C2S_TurretSettingsPacket, PacketBuffer> encoder, Decoder decoder, BiConsumer<C2S_TurretSettingsPacket, TurretEntity> handler) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.handler = handler;
        }

        @FunctionalInterface
        private static interface Decoder {
            public C2S_TurretSettingsPacket decode(int var1, SettingsType var2, PacketBuffer var3);
        }
    }
}

